package com.example.bytesbee.alphabets.activities;

import android.content.Intent;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.example.bytesbee.alphabets.activities.R;
import com.example.bytesbee.alphabets.activities.constants.IConstants;
import com.example.bytesbee.alphabets.activities.utils.Utils;
import com.example.bytesbee.alphabets.activities.views.GestureDetectListner;
import com.example.bytesbee.alphabets.activities.views.GestureDetectListner.SimpleGestureListener;

/**
 * @author Prashant
 * @company BytesBee
 * @link http://bytesbee.com/
 */
public class CommonTTSActivity extends BaseActivity implements SimpleGestureListener, View.OnClickListener {

    private ImageView imgView;
    private TextView txtView;
    private GestureDetectListner detector;
    private int position = 0;
    private int[] images;
    private String[] sounds;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        setContentView(R.layout.common_activity);
        super.onCreate(savedInstanceState);

        Intent intent = getIntent();
        images = intent.getIntArrayExtra(IConstants.EXTRA_IMAGES);
        sounds = intent.getStringArrayExtra(IConstants.EXTRA_SOUNDS);

        imgView = findViewById(R.id.imgView);
        txtView = findViewById(R.id.txtView);
        detector = new GestureDetectListner(this, this);

        //imgView.setImageResource(images[position]);
        //loadAudio(position);
        updateActivity(position);

        imgView.setOnClickListener(this);
        btnPrevious.setOnClickListener(this);
        btnNext.setOnClickListener(this);
        play.setOnClickListener(this);

        Utils.loadBannerAd(mActivity);
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.play || id == R.id.imgView) {
            updateActivity(position);
        } else if (id == R.id.btnPrev) {
            showPrevious();
        } else if (id == R.id.btnNext) {
            showNext();
        }
    }

    private void loadAudio(final int position) {
        if (session.isVibrateOn()) {
            Utils.setVibrate(mActivity);
        }
        if (session.isSoundOn()) {
            UIApplication.speak(sounds[position]);
        }
    }

    private void updateActivity(final int position) {
        bounceView(imgView);
        bounceView(txtView);
        txtView.setText(sounds[position]);
        imgView.setImageResource(images[position]);
        loadAudio(position);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent me) {
        this.detector.onTouchEvent(me);
        return super.dispatchTouchEvent(me);
    }

    @Override
    public void onSwipe(int direction) {
        switch (direction) {

            case GestureDetectListner.SWIPE_RIGHT:

                showPrevious();

                break;

            case GestureDetectListner.SWIPE_LEFT:

                showNext();

                break;
        }

    }


    private void showPrevious() {
        if (position > 0) {
            updateActivity(position - 1);
            position = position - 1;
        } else {
            updateActivity((images.length - 1));
            position = images.length - 1;
        }
    }

    private void showNext() {
        if (position < (images.length - 1)) {
            updateActivity(position + 1);
            position = position + 1;
        } else {
            updateActivity(0);
            position = 0;
        }
    }

    protected void onPause() {
        super.onPause();
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }
}